import React from 'react';

import { EmptyContainerType } from '../models';

import { ReactComponent as AccessDeniedPicture } from './access_denied.svg';
import { ReactComponent as BadRequestPicture } from './bad_request.svg';
import { ReactComponent as EmptyStatePicture } from './empty_state.svg';
import { ReactComponent as ErrorPicture } from './error.svg';
import { ReactComponent as NotFoundPicture } from './not_found.svg';

const map = new Map<EmptyContainerType, React.ComponentType>([
   [EmptyContainerType.AccessDenied, AccessDeniedPicture],
   [EmptyContainerType.BadRequest, BadRequestPicture],
   [EmptyContainerType.Error, ErrorPicture],
   [EmptyContainerType.NotFound, NotFoundPicture],
]);

interface Props {
   type: EmptyContainerType;
}

export const EmptyContainerPicture = ({ type }: Props) => {
   const Icon = map.get(type);

   return Icon ? <Icon /> : <EmptyStatePicture />;
};
