import React, { Component, PropsWithChildren } from 'react';

import { ErrorBoundaryScreen } from './__screen/ErrorBoundaryScreen';

interface State {
   error: Error | null;
}

export class ErrorBoundary extends Component<PropsWithChildren<{}>, State> {
   static getDerivedStateFromError(error: any): Partial<State> {
      return { error };
   }

   constructor(props: PropsWithChildren<{}>) {
      super(props);

      this.state = { error: null };
   }

   public render() {
      return this.state.error ? <ErrorBoundaryScreen error={this.state.error} /> : this.props.children;
   }
}
