import * as React from 'react';
import { useContext, useEffect } from 'react';

import { ModalContainer } from '../../../../modals';
import { FeedbackButton } from '../../../../small_components';
import { ProjectContext } from '../../../models/ProjectContext';
import { EmptyContainer, EmptyContainerType } from '../../EmptyContainer';

import classes from './ErrorBoundaryScreen.module.css';

interface Props {
   error: Error;
}

export const ErrorBoundaryScreen: React.FC<Props> = React.memo(({ error }) => {
   const projectContext = useContext(ProjectContext);

   useEffect(() => {
      if (projectContext.onError) {
         projectContext.onError(error);
      }
   }, [error, projectContext]);

   return (
      <>
         <ModalContainer />

         <EmptyContainer
            type={EmptyContainerType.Error}
            title={'JavaScript error has happened'}
            className={classes.container}
            action={{ text: 'Go to home page', link: projectContext.homeUrl }}
            description={
               <div className={classes.body}>
                  <p>
                     Try to <a href={window.location.href}>reload page</a> or return to{' '}
                     <a href={projectContext.homeUrl}> start page</a>.
                  </p>

                  {projectContext?.feedbackFormId ? (
                     <p>
                        If reloading hasn't helped, write to support by clicking this icon:
                        <FeedbackButton formId={projectContext.feedbackFormId} title={'Bug report or feedback'} />
                     </p>
                  ) : null}
               </div>
            }
         />
      </>
   );
});

ErrorBoundaryScreen.displayName = 'ErrorBoundaryScreen';
