import React, { ComponentType } from 'react';

import { ErrorBoundary } from './ErrorBoundary';

/**
 * HoC для компонента, при любых ошибках рендера,вместо компонента покажется ошибка,
 * не завершая весь цикл рендера реакта (не падая глобально)
 */
export function wrapFaultTolerant<P = any>(Cmp: ComponentType<P>): ComponentType<P> {
   function Wrapped(props: P) {
      return (
         <ErrorBoundary>
            <Cmp {...props} />
         </ErrorBoundary>
      );
   }

   Wrapped.displayName = `faultTolerant(${Cmp.name ?? Cmp.displayName})`;

   return Wrapped;
}
