import React from 'react';
import { Route, Switch, useRouteMatch } from 'react-router-dom';

import { AppRouteProps } from '../../models/AppRouteProps';

import { SwitchRoutesError404Page } from './__Error404Page/SwitchRoutesError404Page';
import { RouteWithErrorBoundary } from './RouteWithErrorBoundary';

function addPrefix(prefix: string, path: string | readonly string[] | undefined) {
   if (prefix === '/') {
      return path;
   }

   if (Array.isArray(path)) {
      return path.map(p => prefix + p);
   }

   if (typeof path === 'string') {
      return prefix + path;
   }

   return path;
}

interface Props {
   children: AppRouteProps[];
   doNotAddPrefix?: boolean;
   faultTolerant?: boolean;
}

export function SwitchRoutes({ children, doNotAddPrefix = false, faultTolerant = true }: Props) {
   const match = useRouteMatch();

   return (
      <Switch>
         {children.map(({ path, ...route }) => {
            const prefixed = doNotAddPrefix ? path : addPrefix(match.path, path);
            // console.log({ match: match.path, path, prefixed });
            const key = (path as any) || 'index';

            return faultTolerant ? (
               <RouteWithErrorBoundary key={key} path={prefixed} {...route} />
            ) : (
               <Route key={key} path={prefixed} {...route} />
            );
         })}

         <Route component={SwitchRoutesError404Page} />
      </Switch>
   );
}

SwitchRoutes.displayName = 'SwitchRoutes';
