import React from 'react';

import { useTitle } from '../../../useTitle';
import { EmptyContainer, EmptyContainerType } from '../../EmptyContainer';

export const SwitchRoutesError404Page: React.FC = () => {
   useTitle('Page not found', []);

   return (
      <EmptyContainer
         type={EmptyContainerType.NotFound}
         title={'Error 404: Page not found'}
         description={'This url is not supported'}
         action={{ text: 'To home page', link: '/' }}
      />
   );
};

SwitchRoutesError404Page.displayName = 'SwitchRoutesError404Page';
