import { useContext, useEffect, useRef } from 'react';

import { ProjectContext } from './models/ProjectContext';

export function useTitle(title: string, deps?: any[]) {
   if (deps === undefined) {
      deps = [];
   }

   const projectContext = useContext(ProjectContext);

   const previousTitle = useRef(document.title);

   useEffect(() => {
      previousTitle.current = document.title;

      document.title = title ? `${title} / ${projectContext.name}` : projectContext.name;

      return () => {
         if (previousTitle.current) {
            document.title = previousTitle.current;
         } else {
            document.title = projectContext.name;
         }
      };
      // eslint-disable-next-line react-hooks/exhaustive-deps
   }, [...deps, title]);
}
