interface YandexMetrikaOptions {
   accurateTrackBounce: boolean;
   clickmap: boolean;
   ecommerce: string | undefined;
   trackHash: boolean;
   trackLinks: boolean;
   webvisor: boolean;
}

interface IYandexMetrika {
   a: any[];
   l: number;

   (id: number, method: string, options: YandexMetrikaOptions): void;
}

declare global {
   // tslint:disable-next-line
   interface Window {
      ym: IYandexMetrika;
   }
}

const defaultOptions: YandexMetrikaOptions = {
   accurateTrackBounce: true,
   clickmap: true,
   ecommerce: undefined,
   trackHash: false,
   trackLinks: true,
   webvisor: false,
};

export function initMetrika(id: number, options?: Partial<YandexMetrikaOptions>) {
   if (!window.ym) {
      window.ym = function metrikaGlobal() {
         // eslint-disable-next-line prefer-rest-params
         (window.ym.a = window.ym.a || []).push(arguments);
      } as any;
   }

   window.ym.l = new Date().getTime();

   const scriptEl = document.createElement('script');
   scriptEl.async = true;
   scriptEl.src = 'https://mc.yandex.ru/metrika/tag.js';

   const firstScript = document.getElementsByTagName('script')[0];
   firstScript.parentNode!.insertBefore(scriptEl, firstScript);

   window.ym(id, 'init', {
      ...defaultOptions,
      ...options,
   });
}
