import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { outlineDecorator } from '../../_storybook';
import { SmartTab, SmartTabs } from '../../small_components';
import { ModalLayoutProps } from '../models';

import { ModalLayout } from './ModalLayout';

const Template: Story<ModalLayoutProps> = props => (
   <ModalLayout
      {...props}
      onOk={action('onOk')}
      onDismiss={action('onDismiss')}
      footerLeft={<b>Footer additional node</b>}
      tabs={
         <SmartTabs>
            <SmartTab id={'tab1'} title={'Tab1'}>
               Tab1
            </SmartTab>
            <SmartTab id={'tab2'} title={'Tab2'}>
               Tab2
            </SmartTab>
            <SmartTab id={'tab3'} title={'Tab3'}>
               Tab3
            </SmartTab>
         </SmartTabs>
      }
   >
      {props.children ?? 'Body of modal'}
   </ModalLayout>
);
export const Regular = Template.bind({});
Regular.args = {
   children: 'Body of modal',
   title: 'Usual usage of ModalLayout, just body',
};

export const AllFeatures = Template.bind({});
AllFeatures.args = {
   disabled: false,
   title: 'Title of modal',
   subtitle: 'subtitle',
   okLabel: 'okLabel',
   cancelLabel: 'cancelLabel',
};

export const CustomFooter = Template.bind({});
CustomFooter.args = {
   children: 'Body',
   customFooter: 'customFooter',
   showFooter: false,
   title: 'Title of modal',
};

export default {
   decorators: [outlineDecorator],
   title: 'modals/ModalLayout',
} as Meta;
