import { Dialog } from '@yandex-cloud/uikit';
import * as React from 'react';
import { PropsWithChildren } from 'react';

import { ModalLayoutProps } from '../models';

import classes from './ModalLayout.module.css';

export const ModalLayout = ({
   'data-e2e': dataE2E,
   cancelLabel = 'Cancel',
   children,
   customFooter,
   disabled = false,
   footerLeft = null,
   okLabel = 'OK',
   onDismiss,
   onOk,
   showFooter = true,
   subtitle,
   tabs = null,
   title,
}: PropsWithChildren<ModalLayoutProps>) => {
   if (showFooter && !onOk) {
      throw new Error('`onOk` is required if showFooter is true');
   }

   if (customFooter && showFooter) {
      throw new Error('To use `customFooter` set `showFooter` to false');
   }

   return (
      <div data-e2e={dataE2E}>
         {title ? <Dialog.Header caption={title} /> : null}

         {subtitle ? <div className={classes.headerSubtitle}>{subtitle}</div> : null}

         <Dialog.Body>
            {tabs ? <div className={classes.tabs}>{tabs}</div> : null}
            {children}
         </Dialog.Body>

         {showFooter ? (
            <Dialog.Footer
               showError={false}
               preset={'default'}
               listenKeyEnter={false}
               onClickButtonApply={onOk as any}
               textButtonApply={okLabel as any}
               propsButtonApply={
                  {
                     children: okLabel,
                     disabled,
                     attrs: { 'data-e2e': 'Modal:ok' },
                     size: 's',
                  } as any
               }
               textButtonCancel={cancelLabel as any}
               onClickButtonCancel={onDismiss as any}
               propsButtonCancel={{
                  children: cancelLabel,
                  extraProps: { 'data-e2e': 'Modal:cancel' },
                  size: 's',
               }}
            >
               {footerLeft}
            </Dialog.Footer>
         ) : customFooter ? (
            <div className={classes.footer}>{customFooter}</div>
         ) : null}
      </div>
   );
};

ModalLayout.displayName = 'ModalLayout';
