import { ComponentType } from 'react';
import { Observable, Subject } from 'rxjs';

import { defaultModalOptions, IModalConfig, IModalProps, ModalLayoutProps, ModalOptions } from './models';

class ModalService {
   public modals: Observable<IModalConfig<any, any>>;

   private modalsSubject = new Subject<IModalConfig<any, any>>();

   constructor() {
      this.modals = this.modalsSubject.asObservable();
   }

   public open<R, P>(component: ComponentType<P & IModalProps<R>>, props: P, options?: ModalOptions): Observable<R> {
      return this.internalOpen(false, undefined, component, props, options);
   }

   public openWithLayout<R, P>(
      layoutProps: ModalLayoutProps,
      component: ComponentType<P & IModalProps<R>>,
      props: P,
      options?: ModalOptions,
   ): Observable<R> {
      return this.internalOpen(true, layoutProps, component, props, options);
   }

   private internalOpen<R, P>(
      withLayout: boolean,
      layoutProps: ModalLayoutProps | undefined,
      component: ComponentType<P & IModalProps<R>>,
      props: P,
      options?: ModalOptions,
   ): Observable<R> {
      return new Observable(observer => {
         this.modalsSubject.next({
            options: { ...defaultModalOptions, ...options },
            component,
            layoutProps,
            observer,
            props,
            withLayout,
         });
      });
   }
}

export const modalService = new ModalService();
