import { DialogProps } from '@yandex-cloud/uikit';
import { ComponentType, ReactNode, SyntheticEvent } from 'react';
import { Subscriber } from 'rxjs';

export interface IModalProps<R> {
   cancel(reason?: string): void;

   ok(result: R): void;
}

export interface ModalLayoutProps {
   children?: ReactNode;
   cancelLabel?: ReactNode;
   customFooter?: ReactNode;
   'data-e2e'?: string;
   disabled?: boolean;
   footerLeft?: ReactNode;
   okLabel?: ReactNode;
   onDismiss: (e: SyntheticEvent) => void;
   onOk?: (e: SyntheticEvent) => void;
   showFooter?: ReactNode;
   subtitle?: ReactNode;
   tabs?: ReactNode;
   title: ReactNode;
}

export interface ModalOptions {
   /**
    * true by default
    */
   closeOnOutsideClick?: boolean;

   dialogProps?: Omit<
      DialogProps,
      'open' | 'onClose' | 'children' | 'hasCloseButton' | 'onOutsideClick' | 'onEscapeKeyDown'
   >;

   /**
    * true by default
    */
   hasButtonClose?: boolean;
}

export const defaultModalOptions: Required<ModalOptions> = {
   closeOnOutsideClick: true,
   hasButtonClose: true,
   dialogProps: {},
};

export interface IModalConfig<R, P extends IModalProps<R>> {
   component: ComponentType<P>;
   layoutProps?: ModalLayoutProps;
   observer: Subscriber<R>;
   options: Required<ModalOptions>;
   props: P;
   withLayout: boolean;
}

export const DISMISS_REASON = 'dismiss';
