import { useEffect, useState } from 'react';
import { BehaviorSubject } from 'rxjs';

/**
 * Позволяет брать актуальное значение из BehaviourSubject,
 * перерендыревая компонент при его изменении
 */
export function useBehaviourSubject<T>(subject: BehaviorSubject<T>): T {
   const [value, setValue] = useState(subject.value);

   useEffect(() => {
      const s = subject.subscribe(setValue);

      return () => s.unsubscribe();
   }, [subject]);

   return value;
}
