import { useEffect } from 'react';

export function useBodyStyles(styles: Partial<CSSStyleDeclaration>) {
   useEffect(() => {
      const keys = Object.keys(styles);
      const before: Partial<CSSStyleDeclaration> = {};

      keys.forEach(key => {
         before[key] = document.body.style[key];
         document.body.style[key] = styles[key];
      });

      return () => {
         keys.forEach(key => {
            document.body.style[key] = before[key];
         });
      };
   }, [styles]);
}
