import { useCallback, useState } from 'react';

const emptyRect: Partial<DOMRect> = {
   bottom: 0,
   height: 0,
   left: 0,
   right: 0,
   top: 0,
   width: 0,
   x: 0,
   y: 0,
};

export function useBoundingClientRect(): [(n: HTMLElement | null) => void, Partial<DOMRect>] {
   const [value, setValue] = useState(emptyRect);

   const ref = useCallback((node: HTMLElement | null) => {
      setValue(node !== null ? node.getBoundingClientRect() : emptyRect);
   }, []);

   return [ref, value];
}
