import { useEffect, useState } from 'react';

/**
 * Притормаживает обновление значения на delay миллисекунд. Удобно для suggestions.
 *
 * @see https://dev.to/gabe_ragland/debouncing-with-react-hooks-jci
 */
export function useDebouncedValue<T>(value: T, delay: number): T {
   const [debouncedValue, setDebouncedValue] = useState(value);

   useEffect(() => {
      const handler = setTimeout(() => setDebouncedValue(value), delay);

      return () => clearTimeout(handler);
   }, [delay, value]);

   return debouncedValue;
}
