import { useEffect, useMemo } from 'react';
import { Subject } from 'rxjs';

/**
 * Альтернатива withDismounted, но на хуках
 */
export function useDismounted() {
   const dismounted = useMemo(() => new Subject(), []);

   useEffect(
      () => () => {
         dismounted.next();
         dismounted.complete();
      },
      [dismounted],
   );

   return dismounted;
}
