import { useEffect, useState } from 'react';
import { Observable } from 'rxjs';

import { IApiError } from '../http';

// eslint-disable-next-line @typescript-eslint/no-unused-vars
const emptyErrorHandler = (error: string | IApiError): void => {};

export function useObservableValue<T>(
   obs: Observable<T>,
   errorHandler = emptyErrorHandler,
   deps: any[] = [],
): T | null {
   const [value, setValue] = useState<T | null>(null);

   useEffect(() => {
      const s = obs.subscribe(setValue, errorHandler);

      return () => s.unsubscribe();
      // eslint-disable-next-line react-hooks/exhaustive-deps
   }, deps);

   return value;
}
