import { Meta } from '@storybook/react';
import { Button } from '@yandex-cloud/uikit';
import * as React from 'react';
import { useCallback, useState } from 'react';

import { UpdateTimerMode, useUpdateTimer } from './useUpdateTimer';

const RegularStory = () => {
   const [counter, setCounter] = useState(0);

   const counterCallback = useCallback(() => {
      setCounter(c => c + 1);
   }, []);

   useUpdateTimer({
      callback: counterCallback,
      fast: 500,
      mode: UpdateTimerMode.Slow,
      slow: 2000,
   });

   return <Button>{counter}</Button>;
};

export const Regular = () => <RegularStory />;

export default {
   title: 'react_hooks/useUpdateTimer',
} as Meta;
