import { useEffect } from 'react';

export enum UpdateTimerMode {
   Fast = 'fast',
   Slow = 'slow',
}

interface IUpdateTimerConfig {
   fast: number;
   mode: UpdateTimerMode;
   slow: number;

   callback(): void;
}

export function useUpdateTimer(config: IUpdateTimerConfig) {
   const { callback } = config;

   const timeout = config[config.mode];

   useEffect(() => {
      if (timeout === -1) {
         return undefined;
      }

      let timer = window.setTimeout(function restart() {
         callback();
         timer = window.setTimeout(restart, timeout);
      }, timeout);

      return () => {
         window.clearTimeout(timer);
      };
   }, [timeout, callback]);
}
