import { useEffect } from 'react';
import { RouteComponentProps } from 'react-router';

// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { toQuery } from '../helpers/url/toQuery';

export function useUrlUpdater<T>(props: RouteComponentProps<T>, getParams: () => T, deps: any[]) {
   useEffect(
      () => {
         const search = toQuery(getParams());
         if (search !== props.location.search.replace(/^\?/, '')) {
            props.history.push({ search });
         }
      },
      // eslint-disable-next-line react-hooks/exhaustive-deps
      [...deps, getParams, props.location, props.history],
   );
}
