import { useEffect } from 'react';

export function useWindowChangeDimensions(handler: () => void) {
   handler();

   useEffect(() => {
      window.addEventListener('scroll', handler);
      window.addEventListener('resize', handler);

      return () => {
         window.removeEventListener('scroll', handler);
         window.removeEventListener('resize', handler);
      };
   }, [handler]);
}
