import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { outlineDecorator } from '../../_storybook';

import { AccentFirstLetter } from './AccentFirstLetter';

interface StoryArgs {
   blue: boolean;
   value: string;
}

const Template: Story<StoryArgs> = ({ value, blue }) => <AccentFirstLetter value={value} blue={blue} />;

export const Usual = Template.bind({});
Usual.args = { blue: false, value: 'Some Login' };

export const OneLetter = Template.bind({});
Usual.args = { blue: false, value: 's' };

export const Empty = Template.bind({});
Usual.args = { blue: false, value: '' };

export default {
   decorators: [outlineDecorator],
   title: 'small_components/AccentFirstLetter',
} as Meta;
