import React, { ReactNode } from 'react';

import { classNames } from '../../formatters';

import classes from './AccentFirstLetter.module.css';

interface Props {
   blue?: boolean;
   value: ReactNode;
}

export const AccentFirstLetter = ({ value, blue = false }: Props) => (
   <span className={classNames(classes.accent, { [classes.blue]: blue })}>{value}</span>
);
