import { boolean, text } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import * as React from 'react';

import { outlineDecorator, systemUsersDecorator } from '../../_storybook';

import { Avatar } from './Avatar';

export const Empty = () => <Avatar login={''} big={boolean('big', false)} />;

export const WallE = () => <Avatar login={'wall-e'} big={boolean('big', false)} />;

export const IDM = () => <Avatar login={'idm'} big={boolean('big', false)} />;

export const Custom = () => <Avatar login={text('login', 'khoden')} big={boolean('big', false)} />;

export default {
   decorators: [outlineDecorator, systemUsersDecorator],
   title: 'small_components/Avatar',
} as Meta;
