import { action } from '@storybook/addon-actions';
import { Meta } from '@storybook/react';
import React from 'react';

import { Banner } from './Banner';

export const Action = () => (
   <Banner title={'New version available'} action={'Reload the page'} onAction={action('onAction')}>
      The new version of the web application is ready to use
   </Banner>
);

export const Double = () => (
   <>
      <Banner title={'New version available'} action={'Reload the page'} onAction={action('onAction')}>
         The new version of the web application is ready to use
      </Banner>
      <Banner title={'New version available'} action={'Reload the page'} onAction={action('onAction')}>
         The new version of the web application is ready to use
      </Banner>
   </>
);

export const Link = () => (
   <Banner title={'New version available'} action={'Reload the page'} link={'https://ya.ru/'}>
      The new version of the web application is ready to use
   </Banner>
);

export const Closable = () => (
   <Banner title={'New version available'} action={'Reload the page'} link={'/xxx'} onClose={action('onClose')}>
      The new version of the web application is ready to use
   </Banner>
);

export const Empty = () => <Banner title={'New version available'} action={'Reload the page'} link={'/xxx'} />;

export default {
   title: 'small_components/Banner',
} as Meta;
