import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button } from '@yandex-cloud/uikit';
import React from 'react';

import { icuiTimes } from '../../_styles/@fortawesome/ui-libs-icons';
import { classNames } from '../../formatters';
import { ButtonLink } from '../ButtonLink/ButtonLink';

import { BannerBackground } from './__Background/BannerBackground';
import classes from './Banner.module.css';

interface Props {
   action: string;
   link?: string;
   title: string;

   onAction?(): void;

   onClose?(): void;
}

export const Banner: React.FC<Props> = React.memo(({ title, children, action, onAction, link, onClose }) => (
   <div className={classNames(classes.banner, { [classes.closable]: onClose })}>
      <BannerBackground />

      <div className={classes.info}>
         <h3 className={classes.title}>{title}</h3>
         {children && <p>{children}</p>}
      </div>

      {onAction && (
         <Button view={'action'} onClick={onAction} extraProps={{ 'data-e2e': 'Banner:action' }}>
            {action}
         </Button>
      )}

      {link && (
         <ButtonLink view={'action'} to={link} external={true} data-e2e={'Banner:link'}>
            {action}
         </ButtonLink>
      )}

      {onClose && (
         <Button
            view={'flat'}
            size={'m'}
            className={classes.close}
            extraProps={{ 'data-e2e': 'Banner:close' }}
            title={'Close the banner forever'}
            onClick={onClose}
         >
            <FontAwesomeIcon icon={icuiTimes} size={'sm'} />
         </Button>
      )}
   </div>
));

Banner.displayName = 'Banner';
