import * as React from 'react';

import { classNames } from '../../formatters';

import styles from './BottomFooter.module.css';

interface Props {
   className?: string;
   'data-e2e'?: string;
}

export const BottomFooter: React.FC<Props> = React.memo(
   ({ className = '', 'data-e2e': dataE2E = 'BottomFooter', children }) => (
      <div className={classNames(styles.bottomFooter, className)} data-e2e={dataE2E}>
         {children}
      </div>
   ),
);
