import { ComponentMeta, Story } from '@storybook/react';
import { Card } from '@yandex-cloud/uikit';
import React from 'react';
import { Link, MemoryRouter, Route } from 'react-router-dom';

import { ButtonLink, ButtonLinkProps } from './ButtonLink';

const Template: Story<ButtonLinkProps> = args => <ButtonLink {...args} />;

export const RouterLink = Template.bind({});
RouterLink.args = {
   children: 'go to page',
   to: '/page',
};
RouterLink.decorators = [
   story => (
      <>
         {story()}

         <Route path={'/page'}>
            <Card>
               <h1>This is page on `/page`</h1>
               <Link to={'/'}>Back</Link>
            </Card>
         </Route>
      </>
   ),
   story => <MemoryRouter>{story()}</MemoryRouter>,
];

export const ExternalLink = Template.bind({});
ExternalLink.args = {
   children: 'open ya.ru',
   external: true,
   to: 'https://ya.ru',
};

export default {
   args: {
      'data-e2e': 'link-e2e',
      external: false,
   },
   component: ButtonLink,
   title: 'small_components/ButtonLink',
} as ComponentMeta<typeof ButtonLink>;
