import { Button, ButtonProps } from '@yandex-cloud/uikit';
import React from 'react';
import { Link } from 'react-router-dom';

import { RouterButton } from './RouterButton';

export interface ButtonLinkProps extends ButtonProps {
   'data-e2e'?: string;
   external?: boolean;
   to: string;
}

export const ButtonLink: React.FC<ButtonLinkProps> = React.memo(
   ({ children, to, external = false, 'data-e2e': dataE2e, ...buttonProps }) => {
      return external ? (
         <Button qa={buttonProps.qa ?? dataE2e} {...buttonProps} href={to} target={'_blank'}>
            {children}
         </Button>
      ) : (
         <Link qa={buttonProps.qa ?? dataE2e} component={RouterButton as any} {...buttonProps} to={to}>
            {children}
         </Link>
      );
   },
);

ButtonLink.displayName = 'ButtonLink';
