import { Button, ButtonProps } from '@yandex-cloud/uikit';
import React, { SyntheticEvent, useCallback } from 'react';

export interface RouterButtonProps extends ButtonProps {
   navigate(): void;
}

export const RouterButton = React.forwardRef<HTMLAnchorElement, RouterButtonProps>((props, ref) => {
   const navigate = useCallback(
      (e: SyntheticEvent) => {
         e.preventDefault();
         props.navigate();
      },
      [props],
   );

   return <Button ref={ref} onClick={navigate} {...props} />;
});

RouterButton.displayName = 'RouterButton';
