import React, { ReactNode, SyntheticEvent, useContext, useMemo } from 'react';

import { ActionType, ID } from './CheckboxSelection.state';
import { CheckboxSelectionContext } from './context';

interface Args {
   selected: boolean;

   toggle(e: SyntheticEvent): void;
}

interface Props {
   id: ID;

   children(p: Args): ReactNode;
}

export const CheckboxSelectionItem: React.FC<Props> = React.memo(({ id, children }) => {
   const context = useContext(CheckboxSelectionContext);
   if (!context) {
      throw new Error('use CheckboxSelectionItem inside of CheckboxSelection!');
   }
   const [{ selected }, dispatch] = context;

   const args: Args = useMemo(
      () => ({
         selected: selected.has(id),
         toggle: (e: React.KeyboardEvent<HTMLInputElement>) => {
            const shiftPressed = e.shiftKey !== undefined ? e.shiftKey : Boolean(e.nativeEvent.shiftKey);

            dispatch({ item: id, shiftPressed, type: ActionType.ToggleItem });
         },
      }),
      [dispatch, id, selected],
   );

   return <>{children(args)}</>;
});

CheckboxSelectionItem.displayName = 'CheckboxSelectionItem';
