import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { ClampLines } from './ClampLines';

storiesOf('small_components/ClampLines', module).add('regular', () => (
   <>
      <h3>{'div->br'}</h3>
      <ClampLines count={2}>
         <div style={{ color: 'var(--error-color)' }}>
            free-100230392.wall-e.yandex.net (#100230392): Failed to remove task production-2109933 from CMS: DELETE
            /tasks/production-2109933 request to https://qloud-hfsm-production.n.yandex-team.ru/api/cms CMS failed:
            Server returned an error: Gateway time out.
            <br />
         </div>
         <div>
            ERASING FREE HOST 2019-07-15 18:11:40.251993
            <br />
         </div>
      </ClampLines>

      <br />

      <h3>div</h3>
      <ClampLines count={2}>
         <div style={{ color: 'var(--error-color)' }}>
            free-100230392.wall-e.yandex.net (#100230392): Failed to remove task production-2109933 from CMS: DELETE
            /tasks/production-2109933 request to https://qloud-hfsm-production.n.yandex-team.ru/api/cms CMS failed:
            Server returned an error: Gateway time out.
         </div>
         <div>ERASING FREE HOST 2019-07-15 18:11:40.251993</div>
      </ClampLines>

      <br />

      <h3>short</h3>
      <ClampLines count={2}>
         <div style={{ color: 'var(--error-color)' }}>
            free-100230392.wall-e.yandex.net (#100230392): Failed to remove task production-2109933 from CMS
         </div>
         <div>ERASING FREE HOST 2019-07-15 18:11:40.251993</div>
      </ClampLines>
   </>
));
