import * as React from 'react';
import { CSSProperties, PropsWithChildren } from 'react';

import { classNames } from '../../formatters';

import styles from './ClampLines.module.css';

interface IProps {
   cls?: string;
   count: number;
   enabled?: boolean;
   lineHeight?: number;
}

/**
 * Обрезает большой текстовый блок по кол-ву строк.
 *
 * Довольно спорное решение, работает на основе неофициального API:
 * https://caniuse.com/#feat=css-line-clamp
 *
 * Деградирует в Firefox и IE до простого обрезания по высоте блока
 */
export function ClampLines({
   children,
   count,
   cls = '',
   enabled = true,
   lineHeight = 18.5,
}: PropsWithChildren<IProps>) {
   const style: CSSProperties = enabled ? { maxHeight: lineHeight ? `${count * lineHeight}px` : `${count}em` } : {};

   const classes = classNames(cls, {
      [styles.clampLines]: enabled,
   });

   return (
      <div className={classes} style={style}>
         {children}
      </div>
   );
}

ClampLines.displayName = 'ClampLines';
