import { Meta } from '@storybook/react';
import React from 'react';

import { DevJson } from './DevJson';

const debugValue = {
   stringMap: new Map([['key', 'value']]),
   numberMap: new Map([[1, 'value']]),
   set: new Set([1, 2, 3]),
   array: [1, '2', null, undefined, 12 / 0],
   circular: undefined as any,
   regExp: /bla-bla/,
   longString: new Array(500).fill(' *').join(''),
   date: new Date(),
};
debugValue.circular = debugValue;

export const Default = () => <DevJson>{debugValue}</DevJson>;

export const Opened = () => <DevJson open={true}>{debugValue}</DevJson>;

export const WithSummary = () => <DevJson summary={'Summary'}>{debugValue}</DevJson>;

export default {
   title: 'small_components/DevJson',
} as Meta;
