// noinspection ES6PreferShortImport
import prettyFormat from 'pretty-format';
import React from 'react';

import classes from './DevJson.module.css';

interface Props {
   open?: boolean;
   summary?: string;
}

export const DevJson: React.FC<Props> = ({ open = false, summary = 'Show JSON', children }) => (
   <details open={open} className={classes.devJson}>
      <summary>{summary}</summary>
      <pre>{prettyFormat(children)}</pre>
   </details>
);

DevJson.displayName = 'DevJson';
