import { Meta } from '@storybook/react';
import React from 'react';

import { ExternalLink } from './ExternalLink';

export const Regular = () => <ExternalLink href={'http://google.com'}>Google</ExternalLink>;

export const Grey = () => (
   <ExternalLink href={'http://google.com'} grey={true}>
      Google
   </ExternalLink>
);

export const Big = () => (
   <ExternalLink href={'http://google.com'} style={{ fontSize: '2rem' }}>
      Google
   </ExternalLink>
);

export const CustomColor = () => (
   <ExternalLink href={'http://google.com'} style={{ color: 'green' }}>
      Google
   </ExternalLink>
);

export const MultipleInLine = () => (
   <div style={{ display: 'inline-block', outline: '1px solid red' }}>
      <ExternalLink href={'https://github.com/css-modules/css-modules'}>CSS Modules</ExternalLink>
      <ExternalLink href={'https://github.com/css-modules/css-modules'}>CSS Modules</ExternalLink>
      <ExternalLink href={'https://github.com/css-modules/css-modules'}>CSS Modules</ExternalLink>
      <ExternalLink href={'https://github.com/css-modules/css-modules'}>CSS Modules</ExternalLink>
      <ExternalLink href={'https://github.com/css-modules/css-modules'}>CSS Modules</ExternalLink>
      <ExternalLink href={'https://github.com/css-modules/css-modules'}>CSS Modules</ExternalLink>
   </div>
);

export const MultipleInLine2 = () => (
   <div style={{ display: 'inline-block', outline: '1px solid red' }}>
      <ExternalLink href={'https://github.com/css-modules/css-modules'}>CSS Modules</ExternalLink>
      <ExternalLink href={'https://github.com/css-modules/css-modules'}>CSS Modules</ExternalLink>
      <ExternalLink href={'https://github.com/css-modules/css-modules'}>CSS Modules</ExternalLink>
      <span>inline element after links</span>
   </div>
);

export default {
   title: 'small_components/ExternalLink',
} as Meta;
