import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import React, { AnchorHTMLAttributes } from 'react';

import { faSquareUpRight } from '../../_styles/@fortawesome/pro-regular-svg-icons';
import { classNames } from '../../formatters';

import classes from './ExternalLink.module.css';

interface Props extends AnchorHTMLAttributes<any> {
   grey?: boolean;
}

export const ExternalLink: React.FC<Props> = React.memo(({ grey = false, className, children, ...rest }) => (
   // eslint-disable-next-line jsx-a11y/anchor-is-valid
   <a
      className={classNames(classes.link, className, {
         [classes.grey]: grey,
      })}
      target={'_blank'}
      rel={'noopener noreferrer'}
      {...rest}
   >
      {children}
      <FontAwesomeIcon icon={faSquareUpRight} className={classes.icon} />
   </a>
));

ExternalLink.displayName = 'ExternalLink';
