import { faBug } from '@fortawesome/free-solid-svg-icons/faBug';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button } from '@yandex-cloud/uikit';
import * as React from 'react';
import { useCallback, useEffect } from 'react';

import { Keys } from '../../_models';
import { classNames } from '../../formatters';
import { globalHotKeys, IKey } from '../../hotkeys';
import { modalService } from '../../modals';

import classes from './FeedbackButton.module.css';
import { FeedbackModal } from './FeedbackModal';

interface IProps {
   cls?: string;
   formId: number;
   globalHotKey?: IKey | null;
   title: string;
}

export const FeedbackButton = React.memo(({ cls = '', title, formId, globalHotKey }: IProps) => {
   const open = useCallback(() => {
      const s = modalService
         .open(
            FeedbackModal,
            { formId, title },
            {
               dialogProps: { className: classes.modal },
            },
         )
         .subscribe(
            () => null,
            () => null,
         );

      return () => s.unsubscribe();
   }, [formId, title]);

   useEffect(() => {
      if (globalHotKey === null) {
         return undefined;
      }

      return globalHotKeys.register({
         action: open,
         help: `Show ${title} form`,
         hotKey: globalHotKey || { code: Keys.F1 },
      });
   });

   return (
      <Button
         view={'flat'}
         size={'s'}
         title={'Send feedback or bug report'}
         className={classNames(classes.button, cls)}
         onClick={open}
      >
         <FontAwesomeIcon icon={faBug} fixedWidth={true} size={'lg'} />
      </Button>
   );
});

FeedbackButton.displayName = 'FeedbackButton';
