import * as React from 'react';

import styles from './HighlightedString.module.css';

interface IProps {
   content: string;
   query: string;
}

export const HighlightedString: React.FC<IProps> = ({ query, content }: IProps) => {
   const index = content.toLowerCase().indexOf(query.toLowerCase());
   if (index === -1) {
      // eslint-disable-next-line react/jsx-no-useless-fragment
      return <>{content}</>;
   }

   const before = content.slice(0, index);
   const after = content.slice(index + query.length);
   const highlighted = content.slice(index, index + query.length);

   return (
      <>
         {before}
         <span className={styles.highlighted}>{highlighted}</span>
         {after}
      </>
   );
};

HighlightedString.displayName = 'HighlightedString';
