import { Meta } from '@storybook/react';
import { TextInput } from '@yandex-cloud/uikit';
import * as React from 'react';

import { Hint } from './Hint';

export const Empty = () => <Hint text={''} />;

export const PlainText = () => (
   <p>
      Text <Hint text={'this is help message'} />
   </p>
);

export const BigText = () => (
   <h1>
      Text <Hint text={'this is help message'} />
   </h1>
);

export const BigText2 = () => (
   <h1>
      Text
      <br />
      Text second line <Hint text={'this is help message'} />
   </h1>
);

export const JsxText = () => (
   <Hint
      text={
         // eslint-disable-next-line
         <>
            <p>this is help message1</p>
            <p>this is help message2</p>
            <p>this is help message3</p>
         </>
      }
   />
);

export const StopPropagation = () => (
   <form>
      <label htmlFor={'some-checkbox'}>
         some-checkbox (click to this label to focus) <Hint text={'Some hint'} />
      </label>
      <br />
      <TextInput id={'some-checkbox'} />
   </form>
);

export default {
   title: 'small_components/Hint',
} as Meta;
