import { HelpPopover } from '@yandex-cloud/uikit';
import * as React from 'react';
import { ReactNode, SyntheticEvent, useCallback } from 'react';

import { classNames } from '../../formatters';
import { Rows } from '../Rows/Rows';

import classes from './Hint.module.css';

interface IProps {
   className?: string;
   qa?: string;
   text?: ReactNode;
}

export const Hint = React.memo(({ className, text }: IProps) => {
   const preventPropagation = useCallback((e: SyntheticEvent) => {
      e.preventDefault();

      return true;
   }, []);

   // render
   if (!text) {
      return null;
   }

   const content = typeof text === 'string' ? <Rows text={text} /> : text;

   return (
      <HelpPopover
         className={classNames(classes.hint, className)}
         content={<div className={classes.content}>{content}</div>}
         openOnHover={false}
         placement={['bottom-start', 'bottom', 'right']}
         onClick={preventPropagation}
      />
   );
});

Hint.displayName = 'Hint';
