import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import * as React from 'react';

import { Json } from './Json';

export const objectRender = () => (
   <Json obj={{ x: 1, y: '2', z: [3], a: null, b: true }} hidePre={boolean('hidePre', false)} />
);

export const emptyObjectRender = () => <Json obj={{}} hidePre={boolean('hidePre', false)} />;

export const arrayRender = () => <Json obj={[3, '4', null, true, false]} hidePre={boolean('hidePre', false)} />;

export const stringRender = () => <Json obj={'string'} hidePre={boolean('hidePre', false)} />;

export const numberRender = () => <Json obj={1e6} hidePre={boolean('hidePre', false)} />;

export const nullRender = () => <Json obj={null} hidePre={boolean('hidePre', false)} />;

export const undefinedRender = () => <Json obj={undefined} hidePre={boolean('hidePre', false)} />;

export const booleanRender = () => <Json obj={true} hidePre={boolean('hidePre', false)} />;

export const complexTypes = () => (
   <Json
      obj={{
         set: new Set([1, 2, 3]),
         map: new Map([
            ['xxx', 'XXX'],
            ['yyy', 'YYY'],
         ]),
         regExp: /www\.(\w+?).ru/g,
      }}
      hidePre={boolean('hidePre', false)}
   />
);

export const long = () => (
   <div style={{ maxWidth: 400 }}>
      <Json
         obj={{
            field: new Array(100).fill('item ').join(''),
         }}
      />
   </div>
);

export default {
   title: 'small_components/Json',
} as Meta;
