import * as React from 'react';
import ReactJsonSyntaxHighlighter from 'react-json-syntax-highlighter';

import { classNames, json } from '../../formatters';

import classes from './Json.module.css';

(ReactJsonSyntaxHighlighter as any).displayName = 'ReactJsonSyntaxHighlighter';

function forceStringifyObject(o: any): any {
   return JSON.parse(json(o));
}

interface SimpleJsonProps {
   hidePre: boolean;
   type: string;
   value: any;
}

function SimpleJson({ value, type, hidePre }: SimpleJsonProps) {
   return (
      <div className={classNames('ReactJsonSyntaxHighlighter', { [classes.hidePre]: hidePre })}>
         <pre>
            <span className={type}>{JSON.stringify(value)}</span>
         </pre>
      </div>
   );
}

const primitiveTypes = new Set(['string', 'number', 'boolean']);

interface Props {
   className?: string;
   hidePre?: boolean;
   obj: any;
}

export const Json: React.FC<Props> = React.memo(({ obj, className, hidePre = false }) => {
   if (obj === undefined || obj === null) {
      return <SimpleJson value={null} type={'null'} hidePre={hidePre} />;
   }

   // Почему-то в библиотеке не поддерживаются примитивы
   if (primitiveTypes.has(typeof obj)) {
      return <SimpleJson value={obj} type={typeof obj} hidePre={hidePre} />;
   }

   if (Object.keys(obj).length === 0) {
      return <SimpleJson value={obj} type={''} hidePre={hidePre} />;
   }

   return (
      <div className={classNames(classes.wrapper, className, { [classes.hidePre]: hidePre })}>
         <ReactJsonSyntaxHighlighter obj={forceStringifyObject(obj)} />
      </div>
   );
});

Json.displayName = 'Json';
