import { storiesOf } from '@storybook/react';
import { Button } from '@yandex-cloud/uikit';
import * as React from 'react';
import { useState } from 'react';

import { LazyDropdown } from './LazyDropdown';

const InvisibleSwitcherStory = () => {
   const [forceOpen, setForceOpen] = useState(false);
   const toggle = () => setForceOpen(!forceOpen);

   return (
      <>
         <LazyDropdown switcher={<span />} opened={forceOpen}>
            Catch up!
         </LazyDropdown>
         <Button onClick={toggle}>Open</Button>
      </>
   );
};

storiesOf('small_components/LazyDropdown', module)
   .add('regular', () => <LazyDropdown switcher={<button type={'button'}>Click me!</button>}>Catch up!</LazyDropdown>)
   .add('invisible switcher', () => <InvisibleSwitcherStory />)
   .add('long switcher', () => (
      <LazyDropdown switcher={<button type={'button'}>Click me, click me, click me, please!</button>}>
         Catch up!
      </LazyDropdown>
   ));
