import { boolean, select, text } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import { TextAlignProperty } from 'csstype';
import * as React from 'react';

import { Loader } from './Loader';

storiesOf('small_components/Loader', module)
   .add('Empty', () => <Loader />)
   .add('With text', () => <Loader text={text('text', 'Centered by default')} />)
   .add('Left aligned inline', () => <Loader text={'Left aligned'} align={'left'} inline={true} />)
   .add('Center aligned', () => <Loader text={'Explicit centered'} align={'center'} />)
   .add('Right aligned', () => <Loader text={'Right aligned'} align={'right'} />)
   .add('Without text', () => (
      <>
         This inline loader without text:
         <Loader inline={true} />
      </>
   ))
   .add('Customizable', () => (
      <Loader
         text={text('text', 'Customizable text')}
         inline={boolean('inline', false)}
         align={select('align', ['left', 'right', 'center'] as TextAlignProperty[], 'left')}
         cls={text('cls', 'checkGlobalStyle')}
         visible={boolean('visible', true)}
      />
   ));
