import { Spin } from '@yandex-cloud/uikit';
import { TextAlignProperty } from 'csstype';
import * as React from 'react';

import { classNames } from '../../formatters';

import styles from './Loader.module.css';

interface IProps {
   align?: TextAlignProperty;
   cls?: string;
   inline?: boolean;
   text?: string;
   visible?: boolean;
}

export const Loader = React.memo(
   ({ align = 'center', cls = '', inline = false, text = '', visible = true }: IProps) => {
      if (!visible) {
         return null;
      }

      return (
         <div
            data-qa={'Loader'}
            className={classNames(cls, {
               [styles.inline]: inline,
               [styles.loader]: Boolean(text),
            })}
            style={{ textAlign: align }}
         >
            <Spin className={styles.spin} />
            <span>{text}</span>
         </div>
      );
   },
);

Loader.displayName = 'Loader';
