import { string } from 'prop-types';
import * as React from 'react';

import styles from './PageError.module.css';

interface IProps {
   text: string;
}

export class PageError extends React.PureComponent<IProps> {
   public static defaultProps = {};

   public static propTypes = {
      text: string.isRequired,
   };

   public render() {
      return <h2 className={styles.pageError}>{this.props.text}</h2>;
   }
}
