import { boolean, number } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import React, { SyntheticEvent, useState } from 'react';

import { DevJson } from '..';
import { PER_PAGE_DEFAULT } from '../../_models';
import { hotkeysDecorator, modalsSupportDecorator } from '../../_storybook';

import { Pagination } from './Pagination';

export const Regular = () => {
   // hooks
   const [page, setPage] = useState(12);
   const [perPage, setPerPage] = useState(PER_PAGE_DEFAULT);

   // handlers
   const changePage = (e: SyntheticEvent | null, v: number) => setPage(v);
   const changePerPage = (e: SyntheticEvent | null, v: number) => setPerPage(v);

   // render
   return (
      <>
         <Pagination
            hideSinglePage={boolean('hideSinglePage', true)}
            id={'test-pagination'}
            onChange={changePage}
            onPerPageChange={changePerPage}
            perPage={perPage}
            total={number('total', 30)}
            value={page}
         />

         <DevJson open={true}>{{ page, perPage }}</DevJson>
      </>
   );
};

export const SinglePage = () => {
   // hooks
   const [page, setPage] = useState(1);
   const [perPage, setPerPage] = useState(PER_PAGE_DEFAULT);

   // handlers
   const changePage = (e: SyntheticEvent | null, v: number) => setPage(v);
   const changePerPage = (e: SyntheticEvent | null, v: number) => setPerPage(v);

   // render
   return (
      <>
         <Pagination
            hideSinglePage={boolean('hideSinglePage', true)}
            id={'test-pagination'}
            onChange={changePage}
            onPerPageChange={changePerPage}
            perPage={perPage}
            total={number('total', 1)}
            value={page}
         />

         <DevJson open={true}>{{ page, perPage }}</DevJson>
      </>
   );
};

export default {
   decorators: [hotkeysDecorator, modalsSupportDecorator],
   title: 'small_components/Pagination',
} as Meta;
