import { SizeProp } from '@fortawesome/fontawesome-svg-core';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button } from '@yandex-cloud/uikit';
import React from 'react';

import { faXmark } from '../../_styles/@fortawesome/pro-regular-svg-icons';
import { classNames, createE2eSelector } from '../../formatters';

import classes from './RemoveButton.module.css';

export interface RemoveButtonProps {
   className?: string;
   disabled?: boolean;
   qa?: string;
   size?: SizeProp;

   onClick(): void;
}

export const RemoveButton: React.FC<RemoveButtonProps> = React.memo(
   ({ onClick, size = '1x', qa, disabled, className }) => (
      <Button
         className={classNames(classes.button, className)}
         disabled={disabled}
         onClick={onClick}
         qa={createE2eSelector(qa, 'Button:Remove')}
         size={'s'}
         title={'Remove'}
         view={'flat'}
      >
         <FontAwesomeIcon icon={faXmark} className={classes.icon} size={size} />
      </Button>
   ),
);

RemoveButton.displayName = 'RemoveButton';
